<?php

/**

* @version		1.0

* @package		DJ Classifieds

* @subpackage	DJ Classifieds Search Plugin

* @copyright	Copyright (C) 2010 Blue Constant Media LTD, All rights reserved.

* @license		http://www.gnu.org/licenses GNU/GPL

* @autor url    http://design-joomla.eu

* @autor email  contact@design-joomla.eu

* @Developer    Lukasz Ciastek - lukasz.ciastek@design-joomla.eu

* 

* 

* DJ Classifieds is free software: you can redistribute it and/or modify

* it under the terms of the GNU General Public License as published by

* the Free Software Foundation, either version 3 of the License, or

* (at your option) any later version.

*

* DJ Classifieds is distributed in the hope that it will be useful,

* but WITHOUT ANY WARRANTY; without even the implied warranty of

* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

* GNU General Public License for more details.

*

* You should have received a copy of the GNU General Public License

* along with DJ Classifieds. If not, see <http://www.gnu.org/licenses/>.

* 

*/



// no direct access

defined( '_JEXEC' ) or die( 'Restricted access' );



global $mainframe;

if(!is_object($mainframe)) {

	$app =& JFactory::getApplication();

}

else

{

	$app = $mainframe;

}

$app->registerEvent( 'onSearch', 'plgSearchDjclassifiedsItems' );

$app->registerEvent( 'onSearchAreas', 'plgSearchDjclassifiedsAreas' );



JPlugin::loadLanguage( 'plg_search_djclassifieds', JPATH_ADMINISTRATOR );



/**

 * @return array An array of search areas

 */

function &plgSearchDjclassifiedsAreas()

{

	static $areas = array(

		'djclassifieds' => 'DJClassifieds Ads'

	);

	return $areas;

}



function plgSearchDjclassifiedsItems( $text, $phrase='', $ordering='', $areas=null )

{

	$db		=& JFactory::getDBO();

	$searchText = $text;



	//require_once(JPATH_SITE.DS.'components'.DS.'com_djcatalog2'.DS.'helpers'.DS.'route.php');



	if (is_array( $areas )) {

		if (!array_intersect( $areas, array_keys( plgSearchDjclassifiedsAreas() ) )) {

			return array();

		}

	}

	$Itemid='';

	$menus	= &JSite::getMenu();

	foreach($menus->_items as $m){

		if($m->link == 'index.php?option=com_djclassifieds&view=show&cid=0'){

			$Itemid=$m->id;

			break;

		}

	}



	// load plugin params info

 	$plugin =& JPluginHelper::getPlugin('search', 'djclassifieds');

 	$pluginParams = new JParameter( $plugin->params );



	$limit = $pluginParams->def( 'search_limit', 50 );



	$text = trim( $text );

	if ( $text == '' ) {

		return array();

	}



	switch ( $ordering ) {

		case 'alpha':

			$order = 'i.name ASC';

			break;

		case 'category':

			$order = 'c.name ASC';

			break;

		case 'popular':

			$order = 'i.display DESC';

			break;

		case 'newest':

			$order = 'i.date_start DESC';

			break;

		case 'oldest':

			$order = 'i.date_start ASC';

			break;

		default:

			$order = 'i.name ASC';

	}



			$date_time =& JFactory::getDate();

			$date_all=$date_time->toMySQL();

			$date = explode(' ',$date_all);



	$text	= $db->Quote( '%'.$db->getEscaped( $text, true ).'%', false );

	$query = ' SELECT i.id AS id, i.name AS title, i.intro_desc AS intro, c.id AS ccategory_id, c.name AS category, i.description as text '

			. ' FROM #__djcf_items AS i '

			. ' LEFT JOIN #__djcf_categories AS c ON c.id = i.cat_id '

			. ' WHERE ( i.name LIKE '.$text

			. ' OR i.intro_desc LIKE '.$text

			. ' OR i.description LIKE '.$text.' )'

			. ' AND i.published = 1'

			. ' AND i.date_exp > \''.$date[0].'\''

			. ' GROUP BY id'

			. ' ORDER BY '. $order

		;

	$db->setQuery( $query, 0, $limit );

	$rows = $db->loadObjectList();

	

	$count = count( $rows );

	for ( $i = 0; $i < $count; $i++ )

	{

		$rows[$i]->href 	= JRoute::_('index.php?option=com_djclassifieds&view=showitem&cid='.$rows[$i]->ccategory_id.'&id='.$rows[$i]->id.'&Itemid='.$Itemid);

		$rows[$i]->section 	= $rows[$i]->category;

	}

	$return = array();

	

	foreach($rows as $key => $section) {

		$return[] = $section;

	}



	return $return;

}

