<?php
/**
 * @version		1.3 mod_annonces - petites annonces $
 * @package		simple_ads_-_petites_annonces
 * @copyright	Copyright (c) 2011 - All rights reserved.
 * @license		GNU/GPL
 * @author		Anthony JULOU
 * @author mail	ajulou@yahoo.fr
 *
 **/

defined('_JEXEC') or die('Restricted access');





/**


 * Annonce Module helper


 *


 */


class ModAnnoncesListHelper


{





	/**


	 * Method to get the ads


	 *


	 * @access public


	 * @return array


	 */


	function getList(&$params)


	{


		global $mainframe;





		$db			=& JFactory::getDBO();


		


		$order = ( (int)$params->get( 'mode', '1' ) == 1 ? "RAND()" : "a.date DESC");


		


		$query = 'SELECT a.*, c.catname, c.showConstructor'


				.' FROM #__annonces AS a'


				.' LEFT JOIN #__annonces_categories AS c ON c.id = a.categorie'


				.' WHERE c.published = 1 and a.approuved = 1 and a.published = 1'


				. ( $params->get( 'categorie', '0' ) != 0 ? ' AND c.id = ' . $params->get( 'categorie', '1' ) : '')


				.' ORDER BY '.$order


				.' LIMIT '.(int)$params->get( 'count', '1' )


				;


		$db->setQuery($query);


		$rows = $db->loadObjectList();





		$i		= 0;


		$lists	= array();


		foreach ( $rows as $row )


		{


			//cut titel


			$lists[$i]->id = $row->id;


			$lists[$i]->titre = $row->objet;


			$lists[$i]->vignette_url		= Image::vignetteExists( $row->id, 1 );


			$lists[$i]->showConstructor = $row->showConstructor;


			$lists[$i]->constructeur = $row->constructeur;


			$lists[$i]->catname = $row->catname;


			$lists[$i]->objet = $row->objet;


			$lists[$i]->datePubli = JHTML::Date( $row->date, $params->get('formatdate', '%d/%m/%Y') ); 


			$lists[$i]->prix = $row->prix;


			$lists[$i]->currency = $params->get('currency', '$');


			


			$i++;


		}


		return $lists;


	}


}